﻿using System;

class DelegateTree
{
    void A() { Console.Write("A"); }
    void B() { Console.Write("B"); }
    void C() { Console.Write("C"); }
    void D() { Console.Write("D"); }
    void E() { Console.Write("E"); }
    void F() { Console.Write("F"); }
    void G() { Console.Write("G"); }
    void H() { Console.Write("H"); }
    void I() { Console.Write("I"); }

    delegate void VoidFunction();

    static void Main()
    {
        DelegateTree dt = new DelegateTree();
        VoidFunction a = dt.A;
        VoidFunction b = dt.B;
        b += dt.C;
        VoidFunction c = new VoidFunction(b); // Here the explicit
        // use of 'new' avoids simply copying a handle.
        VoidFunction e = dt.E;
        e += dt.G;
        e += dt.H;
        e += dt.I;
        c += dt.D;
        c += e;
        a += c;
        a += dt.F;
        a();
    }
}
